@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 * @property validationOptions Options for enabling various post migration validations. Available options,
 *  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
 *  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
 */
public data class MigrateSqlServerSqlDbTaskInputArgs(
    public val selectedDatabases: Output<List<MigrateSqlServerSqlDbDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val validationOptions: Output<MigrationValidationOptionsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validationOptions(
                validationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateSqlServerSqlDbTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlDbTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases: Output<List<MigrateSqlServerSqlDbDatabaseInputArgs>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var validationOptions: Output<MigrationValidationOptionsArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("oxgcuxebctanclld")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlDbDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("suinetuufxxkdacm")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlDbDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("xnrrkxvardawcqxg")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlDbDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("qfdqwpmfwhppcuur")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("vtarwoekbnppbpiv")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Options for enabling various post migration validations. Available options,
     *  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
     *  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
     */
    @JvmName("atohqxdwcbfhkuvw")
    public suspend fun validationOptions(`value`: Output<MigrationValidationOptionsArgs>) {
        this.validationOptions = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("qnpvjfomkvpwwywl")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlDbDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("ilorwlbnggedslfo")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlDbDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("hdsthkgxgcfjtuud")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlDbDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("pnfxgitoeiejpqir")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlDbDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlDbDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("fbjutowlosonevtl")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlDbDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("cmcbrtjasvcyaljc")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source
     */
    @JvmName("ufniyprobhneblrt")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("pwtxhuhmjwsqykyw")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("qbaxnxyfxcohfwbu")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    /**
     * @param value Options for enabling various post migration validations. Available options,
     *  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
     *  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
     */
    @JvmName("bqaqwahtbujgglhe")
    public suspend fun validationOptions(`value`: MigrationValidationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOptions = mapped
    }

    /**
     * @param argument Options for enabling various post migration validations. Available options,
     *  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
     *  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
     */
    @JvmName("ovvtjwrkayfcvotg")
    public suspend
    fun validationOptions(argument: suspend MigrationValidationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = MigrationValidationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationOptions = mapped
    }

    internal fun build(): MigrateSqlServerSqlDbTaskInputArgs = MigrateSqlServerSqlDbTaskInputArgs(
        selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
        sourceConnectionInfo = sourceConnectionInfo ?: throw
            PulumiNullFieldException("sourceConnectionInfo"),
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
        validationOptions = validationOptions,
    )
}
