@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMIDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs
 * @property backupFilePaths The list of backup files to be used in case of existing backups.
 * @property backupFileShare Backup file share information for backing up this database.
 * @property name Name of the database
 * @property restoreDatabaseName Name of the database at destination
 */
public data class MigrateSqlServerSqlMIDatabaseInputArgs(
    public val backupFilePaths: Output<List<String>>? = null,
    public val backupFileShare: Output<FileShareArgs>? = null,
    public val name: Output<String>,
    public val restoreDatabaseName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMIDatabaseInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMIDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMIDatabaseInputArgs.builder()
            .backupFilePaths(backupFilePaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupFileShare(backupFileShare?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .restoreDatabaseName(restoreDatabaseName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateSqlServerSqlMIDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlMIDatabaseInputArgsBuilder internal constructor() {
    private var backupFilePaths: Output<List<String>>? = null

    private var backupFileShare: Output<FileShareArgs>? = null

    private var name: Output<String>? = null

    private var restoreDatabaseName: Output<String>? = null

    /**
     * @param value The list of backup files to be used in case of existing backups.
     */
    @JvmName("kmrcmsosgexrlyqc")
    public suspend fun backupFilePaths(`value`: Output<List<String>>) {
        this.backupFilePaths = value
    }

    @JvmName("lngmpfjutkmujiep")
    public suspend fun backupFilePaths(vararg values: Output<String>) {
        this.backupFilePaths = Output.all(values.asList())
    }

    /**
     * @param values The list of backup files to be used in case of existing backups.
     */
    @JvmName("vyfasqkbnmnbhfkv")
    public suspend fun backupFilePaths(values: List<Output<String>>) {
        this.backupFilePaths = Output.all(values)
    }

    /**
     * @param value Backup file share information for backing up this database.
     */
    @JvmName("kuooagrksfdgirpc")
    public suspend fun backupFileShare(`value`: Output<FileShareArgs>) {
        this.backupFileShare = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("pmeyhnajadoornxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the database at destination
     */
    @JvmName("kmifolqgqerkonvv")
    public suspend fun restoreDatabaseName(`value`: Output<String>) {
        this.restoreDatabaseName = value
    }

    /**
     * @param value The list of backup files to be used in case of existing backups.
     */
    @JvmName("msypyotskrpurtow")
    public suspend fun backupFilePaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFilePaths = mapped
    }

    /**
     * @param values The list of backup files to be used in case of existing backups.
     */
    @JvmName("cpphggybnmafkuai")
    public suspend fun backupFilePaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupFilePaths = mapped
    }

    /**
     * @param value Backup file share information for backing up this database.
     */
    @JvmName("tyunhmmwacikhntr")
    public suspend fun backupFileShare(`value`: FileShareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFileShare = mapped
    }

    /**
     * @param argument Backup file share information for backing up this database.
     */
    @JvmName("lpthkgmudyhwkyvh")
    public suspend fun backupFileShare(argument: suspend FileShareArgsBuilder.() -> Unit) {
        val toBeMapped = FileShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupFileShare = mapped
    }

    /**
     * @param value Name of the database
     */
    @JvmName("rvgxssfympaysqsf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the database at destination
     */
    @JvmName("phorvvcmhaeprhyy")
    public suspend fun restoreDatabaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restoreDatabaseName = mapped
    }

    internal fun build(): MigrateSqlServerSqlMIDatabaseInputArgs =
        MigrateSqlServerSqlMIDatabaseInputArgs(
            backupFilePaths = backupFilePaths,
            backupFileShare = backupFileShare,
            name = name ?: throw PulumiNullFieldException("name"),
            restoreDatabaseName = restoreDatabaseName ?: throw PulumiNullFieldException("restoreDatabaseName"),
        )
}
