@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskInputArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.BackupMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
 * @property aadDomainName Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
 * @property backupBlobShare SAS URI of Azure Storage Account Container to be used for storing backup files.
 * @property backupFileShare Backup file share information for all selected databases.
 * @property backupMode Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
 * @property selectedAgentJobs Agent Jobs to migrate.
 * @property selectedDatabases Databases to migrate
 * @property selectedLogins Logins to migrate.
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 */
public data class MigrateSqlServerSqlMITaskInputArgs(
    public val aadDomainName: Output<String>? = null,
    public val backupBlobShare: Output<BlobShareArgs>,
    public val backupFileShare: Output<FileShareArgs>? = null,
    public val backupMode: Output<Either<String, BackupMode>>? = null,
    public val selectedAgentJobs: Output<List<String>>? = null,
    public val selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>,
    public val selectedLogins: Output<List<String>>? = null,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskInputArgs.builder()
            .aadDomainName(aadDomainName?.applyValue({ args0 -> args0 }))
            .backupBlobShare(backupBlobShare.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupFileShare(backupFileShare?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupMode(
                backupMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selectedAgentJobs(selectedAgentJobs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .selectedLogins(selectedLogins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateSqlServerSqlMITaskInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlMITaskInputArgsBuilder internal constructor() {
    private var aadDomainName: Output<String>? = null

    private var backupBlobShare: Output<BlobShareArgs>? = null

    private var backupFileShare: Output<FileShareArgs>? = null

    private var backupMode: Output<Either<String, BackupMode>>? = null

    private var selectedAgentJobs: Output<List<String>>? = null

    private var selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>? = null

    private var selectedLogins: Output<List<String>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
     */
    @JvmName("jlklysvmnxweekop")
    public suspend fun aadDomainName(`value`: Output<String>) {
        this.aadDomainName = value
    }

    /**
     * @param value SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("ghqdacerumbgbnub")
    public suspend fun backupBlobShare(`value`: Output<BlobShareArgs>) {
        this.backupBlobShare = value
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("udpcxuknuoxotkik")
    public suspend fun backupFileShare(`value`: Output<FileShareArgs>) {
        this.backupFileShare = value
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
     */
    @JvmName("qidyqlxhmqgrjewx")
    public suspend fun backupMode(`value`: Output<Either<String, BackupMode>>) {
        this.backupMode = value
    }

    /**
     * @param value Agent Jobs to migrate.
     */
    @JvmName("bpvsnomqmebvjkfu")
    public suspend fun selectedAgentJobs(`value`: Output<List<String>>) {
        this.selectedAgentJobs = value
    }

    @JvmName("pphvdvgkabnltuwk")
    public suspend fun selectedAgentJobs(vararg values: Output<String>) {
        this.selectedAgentJobs = Output.all(values.asList())
    }

    /**
     * @param values Agent Jobs to migrate.
     */
    @JvmName("eujbdcjgaqvvuflb")
    public suspend fun selectedAgentJobs(values: List<Output<String>>) {
        this.selectedAgentJobs = Output.all(values)
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("xfpdeuirvhiuphkm")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("kaiitdhpvvpjvfkv")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlMIDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("vikjpgdrenngbcdr")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Logins to migrate.
     */
    @JvmName("lhjxwlksfjdrvlop")
    public suspend fun selectedLogins(`value`: Output<List<String>>) {
        this.selectedLogins = value
    }

    @JvmName("lpcnsgakwtrkxgej")
    public suspend fun selectedLogins(vararg values: Output<String>) {
        this.selectedLogins = Output.all(values.asList())
    }

    /**
     * @param values Logins to migrate.
     */
    @JvmName("qxybnnmggqatjtem")
    public suspend fun selectedLogins(values: List<Output<String>>) {
        this.selectedLogins = Output.all(values)
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("vqusoxkajfiejslh")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("ftkprwamkbfydtxj")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
     */
    @JvmName("trqlurjotbahatlk")
    public suspend fun aadDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadDomainName = mapped
    }

    /**
     * @param value SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("xhnhiblndimqqgho")
    public suspend fun backupBlobShare(`value`: BlobShareArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupBlobShare = mapped
    }

    /**
     * @param argument SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("ilqjkxvutsudrdar")
    public suspend fun backupBlobShare(argument: suspend BlobShareArgsBuilder.() -> Unit) {
        val toBeMapped = BlobShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupBlobShare = mapped
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("ggxaykfaxabxndrk")
    public suspend fun backupFileShare(`value`: FileShareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFileShare = mapped
    }

    /**
     * @param argument Backup file share information for all selected databases.
     */
    @JvmName("vpwdqswbsgxcwajo")
    public suspend fun backupFileShare(argument: suspend FileShareArgsBuilder.() -> Unit) {
        val toBeMapped = FileShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupFileShare = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
     */
    @JvmName("nttwvlfdupciaxfn")
    public suspend fun backupMode(`value`: Either<String, BackupMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
     */
    @JvmName("lqnpxmitadjxmvns")
    public fun backupMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases.
     */
    @JvmName("yykihbgyfamnudox")
    public fun backupMode(`value`: BackupMode) {
        val toBeMapped = Either.ofRight<String, BackupMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Agent Jobs to migrate.
     */
    @JvmName("onfslotrioinaxxx")
    public suspend fun selectedAgentJobs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedAgentJobs = mapped
    }

    /**
     * @param values Agent Jobs to migrate.
     */
    @JvmName("uhabmgaoanykibnf")
    public suspend fun selectedAgentJobs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedAgentJobs = mapped
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("nsciscsfkficxoie")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlMIDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("cxqougowxqmbrdta")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("wjtjqsfctcjisgum")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("fdgysjhdvusoaoxv")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("ovglrnpslvxrulot")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlMIDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Logins to migrate.
     */
    @JvmName("hhdqjfabhudwtidb")
    public suspend fun selectedLogins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedLogins = mapped
    }

    /**
     * @param values Logins to migrate.
     */
    @JvmName("jwawsqvjthhdrdli")
    public suspend fun selectedLogins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedLogins = mapped
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("hxrhcwkcaqmieggm")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source
     */
    @JvmName("iieuruaukppkbgfb")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("pltncnagttkaunbm")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("xyslmdcloerjjppc")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigrateSqlServerSqlMITaskInputArgs = MigrateSqlServerSqlMITaskInputArgs(
        aadDomainName = aadDomainName,
        backupBlobShare = backupBlobShare ?: throw PulumiNullFieldException("backupBlobShare"),
        backupFileShare = backupFileShare,
        backupMode = backupMode,
        selectedAgentJobs = selectedAgentJobs,
        selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
        selectedLogins = selectedLogins,
        sourceConnectionInfo = sourceConnectionInfo ?: throw
            PulumiNullFieldException("sourceConnectionInfo"),
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
    )
}
