@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
 */
public data class MigrateSqlServerSqlMITaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MigrateSqlServerSqlMITaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlMITaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateSqlServerSqlMITaskPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlMITaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MigrateSqlServerSqlMITaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("yrtylnmwnemtdcun")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("viujfgkowjbynirm")
    public suspend fun input(`value`: Output<MigrateSqlServerSqlMITaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
     */
    @JvmName("eudjheulfuvhxibs")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("ohfkfeqnyvwyaqbr")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("ecpolgywrxlceawe")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("yrgpxobavvhnwlff")
    public suspend fun input(`value`: MigrateSqlServerSqlMITaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("jfsbuhfqukktxtlo")
    public suspend fun input(argument: suspend MigrateSqlServerSqlMITaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateSqlServerSqlMITaskInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.SqlServer.AzureSqlDbMI'.
     */
    @JvmName("pdslspaojiyjqsnm")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): MigrateSqlServerSqlMITaskPropertiesArgs =
        MigrateSqlServerSqlMITaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
