@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
 * @property sourceConnectionInfo Information for connecting to source
 * @property ssisMigrationInfo SSIS package migration information.
 * @property targetConnectionInfo Information for connecting to target
 */
public data class MigrateSsisTaskInputArgs(
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val ssisMigrationInfo: Output<SsisMigrationInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSsisTaskInputArgs.builder()
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ssisMigrationInfo(ssisMigrationInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateSsisTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateSsisTaskInputArgsBuilder internal constructor() {
    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var ssisMigrationInfo: Output<SsisMigrationInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value Information for connecting to source
     */
    @JvmName("boihpxvlrswxrffb")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value SSIS package migration information.
     */
    @JvmName("hkvmcagcsjwoeipy")
    public suspend fun ssisMigrationInfo(`value`: Output<SsisMigrationInfoArgs>) {
        this.ssisMigrationInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("jwcakqyeyoslkswk")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("psfusgnnrvuuqwkw")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source
     */
    @JvmName("xkppdbalxehmxfyw")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value SSIS package migration information.
     */
    @JvmName("yjpuarnaddavxgml")
    public suspend fun ssisMigrationInfo(`value`: SsisMigrationInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssisMigrationInfo = mapped
    }

    /**
     * @param argument SSIS package migration information.
     */
    @JvmName("kkmhdxwkgyeyvvwl")
    public suspend fun ssisMigrationInfo(argument: suspend SsisMigrationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SsisMigrationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssisMigrationInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("llriggqsojamqctc")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("uaslxpakjvcxeatk")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigrateSsisTaskInputArgs = MigrateSsisTaskInputArgs(
        sourceConnectionInfo = sourceConnectionInfo ?: throw
            PulumiNullFieldException("sourceConnectionInfo"),
        ssisMigrationInfo = ssisMigrationInfo ?: throw PulumiNullFieldException("ssisMigrationInfo"),
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
    )
}
