@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrationValidationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Types of validations to run after the migration
 * @property enableDataIntegrityValidation Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
 * @property enableQueryAnalysisValidation Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
 * @property enableSchemaValidation Allows to compare the schema information between source and target.
 */
public data class MigrationValidationOptionsArgs(
    public val enableDataIntegrityValidation: Output<Boolean>? = null,
    public val enableQueryAnalysisValidation: Output<Boolean>? = null,
    public val enableSchemaValidation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrationValidationOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MigrationValidationOptionsArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrationValidationOptionsArgs.builder()
            .enableDataIntegrityValidation(enableDataIntegrityValidation?.applyValue({ args0 -> args0 }))
            .enableQueryAnalysisValidation(enableQueryAnalysisValidation?.applyValue({ args0 -> args0 }))
            .enableSchemaValidation(enableSchemaValidation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrationValidationOptionsArgs].
 */
@PulumiTagMarker
public class MigrationValidationOptionsArgsBuilder internal constructor() {
    private var enableDataIntegrityValidation: Output<Boolean>? = null

    private var enableQueryAnalysisValidation: Output<Boolean>? = null

    private var enableSchemaValidation: Output<Boolean>? = null

    /**
     * @param value Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
     */
    @JvmName("hmeebtetigsgoqdq")
    public suspend fun enableDataIntegrityValidation(`value`: Output<Boolean>) {
        this.enableDataIntegrityValidation = value
    }

    /**
     * @param value Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
     */
    @JvmName("myhngamclvtuxxim")
    public suspend fun enableQueryAnalysisValidation(`value`: Output<Boolean>) {
        this.enableQueryAnalysisValidation = value
    }

    /**
     * @param value Allows to compare the schema information between source and target.
     */
    @JvmName("xsjrkwkuubhlgjdc")
    public suspend fun enableSchemaValidation(`value`: Output<Boolean>) {
        this.enableSchemaValidation = value
    }

    /**
     * @param value Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
     */
    @JvmName("iiicvmtxlqiyhxnm")
    public suspend fun enableDataIntegrityValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDataIntegrityValidation = mapped
    }

    /**
     * @param value Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
     */
    @JvmName("nlnuabvlcwyhpcam")
    public suspend fun enableQueryAnalysisValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableQueryAnalysisValidation = mapped
    }

    /**
     * @param value Allows to compare the schema information between source and target.
     */
    @JvmName("kgfgpevmpdgtvccp")
    public suspend fun enableSchemaValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSchemaValidation = mapped
    }

    internal fun build(): MigrationValidationOptionsArgs = MigrationValidationOptionsArgs(
        enableDataIntegrityValidation = enableDataIntegrityValidation,
        enableQueryAnalysisValidation = enableQueryAnalysisValidation,
        enableSchemaValidation = enableSchemaValidation,
    )
}
