@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Mongo Connection
 * @property connectionString ConnectionString to connect to Mongo.
 * @property host Host of mongo connection.
 * @property password Password to connect to Mongo.
 * @property port Port of mongo connection.
 * @property useSsl Whether to UseSsl or UseTls to connect to Mongo. Default is true.
 * @property userName User name to connect to Mongo.
 */
public data class MongoConnectionInformationArgs(
    public val connectionString: Output<String>? = null,
    public val host: Output<String>? = null,
    public val password: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val useSsl: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .useSsl(useSsl?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoConnectionInformationArgs].
 */
@PulumiTagMarker
public class MongoConnectionInformationArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var host: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var useSsl: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value ConnectionString to connect to Mongo.
     */
    @JvmName("gulwkgtkqgthqnpa")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Host of mongo connection.
     */
    @JvmName("rjpuhhgpwerrdyij")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Password to connect to Mongo.
     */
    @JvmName("omgjjqxyjfptjttj")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Port of mongo connection.
     */
    @JvmName("chhfbtbwfuosvqxe")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Whether to UseSsl or UseTls to connect to Mongo. Default is true.
     */
    @JvmName("fdogxlbqttrqvypt")
    public suspend fun useSsl(`value`: Output<Boolean>) {
        this.useSsl = value
    }

    /**
     * @param value User name to connect to Mongo.
     */
    @JvmName("kygissknqkmjtnie")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value ConnectionString to connect to Mongo.
     */
    @JvmName("wshnermqcjgfvjem")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Host of mongo connection.
     */
    @JvmName("jvxqhaoodafejeym")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Password to connect to Mongo.
     */
    @JvmName("qsgwtmftgmecturn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Port of mongo connection.
     */
    @JvmName("uiobxpxicyhuimah")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Whether to UseSsl or UseTls to connect to Mongo. Default is true.
     */
    @JvmName("kgvricflkprobuuf")
    public suspend fun useSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSsl = mapped
    }

    /**
     * @param value User name to connect to Mongo.
     */
    @JvmName("mwsdeaydotaytxob")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): MongoConnectionInformationArgs = MongoConnectionInformationArgs(
        connectionString = connectionString,
        host = host,
        password = password,
        port = port,
        useSsl = useSsl,
        userName = userName,
    )
}
