@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.PostgreSqlConnectionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information for connecting to PostgreSQL server
 * @property databaseName Name of the database
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property port Port for Server
 * @property serverName Name of the server
 * @property trustServerCertificate Whether to trust the server certificate
 * @property type Type of connection info
 * Expected value is 'PostgreSqlConnectionInfo'.
 * @property userName User name
 */
public data class PostgreSqlConnectionInfoArgs(
    public val databaseName: Output<String>? = null,
    public val encryptConnection: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val port: Output<Int>,
    public val serverName: Output<String>,
    public val trustServerCertificate: Output<Boolean>? = null,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.PostgreSqlConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.PostgreSqlConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.PostgreSqlConnectionInfoArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .encryptConnection(encryptConnection?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .serverName(serverName.applyValue({ args0 -> args0 }))
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PostgreSqlConnectionInfoArgs].
 */
@PulumiTagMarker
public class PostgreSqlConnectionInfoArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var encryptConnection: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var serverName: Output<String>? = null

    private var trustServerCertificate: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Name of the database
     */
    @JvmName("pngguokoddurryvr")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("fspgamtbniuumkdb")
    public suspend fun encryptConnection(`value`: Output<Boolean>) {
        this.encryptConnection = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("cmvmmwoliqljyfdk")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Port for Server
     */
    @JvmName("wpglfbsmnuxroayt")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Name of the server
     */
    @JvmName("uvnieiwhriyxwesq")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Whether to trust the server certificate
     */
    @JvmName("brtcwfavhoxjrxxp")
    public suspend fun trustServerCertificate(`value`: Output<Boolean>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'PostgreSqlConnectionInfo'.
     */
    @JvmName("jsgcfkwsbnstuskt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("rcrcmmahmummachp")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("wxfdqgoatrtivbix")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("dwhlbrampfshgiud")
    public suspend fun encryptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptConnection = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("epjpvejqlhknarco")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Port for Server
     */
    @JvmName("pfftqrpkrqjkxcla")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Name of the server
     */
    @JvmName("naijhvicoeplnhlo")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Whether to trust the server certificate
     */
    @JvmName("soyfoeaegfboedqg")
    public suspend fun trustServerCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'PostgreSqlConnectionInfo'.
     */
    @JvmName("yaqmlhmoiucyvxqt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("udjxvlwyqsccqbbd")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): PostgreSqlConnectionInfoArgs = PostgreSqlConnectionInfoArgs(
        databaseName = databaseName,
        encryptConnection = encryptConnection,
        password = password,
        port = port ?: throw PulumiNullFieldException("port"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        trustServerCertificate = trustServerCertificate,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
