@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.SelectedCertificateInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Info for certificate to be exported for TDE enabled databases.
 * @property certificateName Name of certificate to be exported.
 * @property password Password to use for encrypting the exported certificate.
 */
public data class SelectedCertificateInputArgs(
    public val certificateName: Output<String>,
    public val password: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.SelectedCertificateInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.SelectedCertificateInputArgs =
        com.pulumi.azurenative.datamigration.inputs.SelectedCertificateInputArgs.builder()
            .certificateName(certificateName.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectedCertificateInputArgs].
 */
@PulumiTagMarker
public class SelectedCertificateInputArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var password: Output<String>? = null

    /**
     * @param value Name of certificate to be exported.
     */
    @JvmName("diwkkhicjgfjfbxf")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Password to use for encrypting the exported certificate.
     */
    @JvmName("djtpfxgbltkwopxr")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Name of certificate to be exported.
     */
    @JvmName("tlfsacfgggbxssxv")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Password to use for encrypting the exported certificate.
     */
    @JvmName("yeycfeariiykokxd")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    internal fun build(): SelectedCertificateInputArgs = SelectedCertificateInputArgs(
        certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
        password = password ?: throw PulumiNullFieldException("password"),
    )
}
