@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ServiceSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure SKU instance
 * @property capacity The capacity of the SKU, if it supports scaling
 * @property family The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
 * @property name The unique name of the SKU, such as 'P3'
 * @property size The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
 * @property tier The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
 */
public data class ServiceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ServiceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.ServiceSkuArgs =
        com.pulumi.azurenative.datamigration.inputs.ServiceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSkuArgs].
 */
@PulumiTagMarker
public class ServiceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The capacity of the SKU, if it supports scaling
     */
    @JvmName("cveuacpsdmwladyy")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
     */
    @JvmName("uafonrqftfcunycb")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The unique name of the SKU, such as 'P3'
     */
    @JvmName("knldlgmrwshckycf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
     */
    @JvmName("cptkwpifycfgwvrl")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
     */
    @JvmName("etxyrbandxfhipft")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The capacity of the SKU, if it supports scaling
     */
    @JvmName("ftbmogawtauqpomp")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
     */
    @JvmName("fnycoaxsqoygofda")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The unique name of the SKU, such as 'P3'
     */
    @JvmName("qoxcgewqbnfqjjrg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
     */
    @JvmName("escytcvwyrkdwufs")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
     */
    @JvmName("vrmtakeqvekobfke")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ServiceSkuArgs = ServiceSkuArgs(
        capacity = capacity,
        family = family,
        name = name,
        size = size,
        tier = tier,
    )
}
