@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.SsisMigrationInfoArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.SsisMigrationOverwriteOption
import com.pulumi.azurenative.datamigration.kotlin.enums.SsisStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSIS migration info with SSIS store type, overwrite policy.
 * @property environmentOverwriteOption The overwrite option for the SSIS environment migration
 * @property projectOverwriteOption The overwrite option for the SSIS project migration
 * @property ssisStoreType The SSIS store type of source, only SSIS catalog is supported now in DMS
 */
public data class SsisMigrationInfoArgs(
    public val environmentOverwriteOption: Output<Either<String, SsisMigrationOverwriteOption>>? =
        null,
    public val projectOverwriteOption: Output<Either<String, SsisMigrationOverwriteOption>>? = null,
    public val ssisStoreType: Output<Either<String, SsisStoreType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.SsisMigrationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.SsisMigrationInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.SsisMigrationInfoArgs.builder()
            .environmentOverwriteOption(
                environmentOverwriteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .projectOverwriteOption(
                projectOverwriteOption?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .ssisStoreType(
                ssisStoreType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SsisMigrationInfoArgs].
 */
@PulumiTagMarker
public class SsisMigrationInfoArgsBuilder internal constructor() {
    private var environmentOverwriteOption: Output<Either<String, SsisMigrationOverwriteOption>>? =
        null

    private var projectOverwriteOption: Output<Either<String, SsisMigrationOverwriteOption>>? = null

    private var ssisStoreType: Output<Either<String, SsisStoreType>>? = null

    /**
     * @param value The overwrite option for the SSIS environment migration
     */
    @JvmName("bwwaaaqdyxgticcp")
    public suspend
    fun environmentOverwriteOption(`value`: Output<Either<String, SsisMigrationOverwriteOption>>) {
        this.environmentOverwriteOption = value
    }

    /**
     * @param value The overwrite option for the SSIS project migration
     */
    @JvmName("lxkctrdxstauiaij")
    public suspend
    fun projectOverwriteOption(`value`: Output<Either<String, SsisMigrationOverwriteOption>>) {
        this.projectOverwriteOption = value
    }

    /**
     * @param value The SSIS store type of source, only SSIS catalog is supported now in DMS
     */
    @JvmName("urhnebhqbsfucuaj")
    public suspend fun ssisStoreType(`value`: Output<Either<String, SsisStoreType>>) {
        this.ssisStoreType = value
    }

    /**
     * @param value The overwrite option for the SSIS environment migration
     */
    @JvmName("yyedwydltyhoacek")
    public suspend
    fun environmentOverwriteOption(`value`: Either<String, SsisMigrationOverwriteOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentOverwriteOption = mapped
    }

    /**
     * @param value The overwrite option for the SSIS environment migration
     */
    @JvmName("ayslgjroalxymuaj")
    public fun environmentOverwriteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SsisMigrationOverwriteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentOverwriteOption = mapped
    }

    /**
     * @param value The overwrite option for the SSIS environment migration
     */
    @JvmName("omxkisgnbbnwomqt")
    public fun environmentOverwriteOption(`value`: SsisMigrationOverwriteOption) {
        val toBeMapped = Either.ofRight<String, SsisMigrationOverwriteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentOverwriteOption = mapped
    }

    /**
     * @param value The overwrite option for the SSIS project migration
     */
    @JvmName("fphfnfsmmutuulox")
    public suspend
    fun projectOverwriteOption(`value`: Either<String, SsisMigrationOverwriteOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectOverwriteOption = mapped
    }

    /**
     * @param value The overwrite option for the SSIS project migration
     */
    @JvmName("oyxvwlxwurwjtiee")
    public fun projectOverwriteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SsisMigrationOverwriteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectOverwriteOption = mapped
    }

    /**
     * @param value The overwrite option for the SSIS project migration
     */
    @JvmName("oneibgupjngoeyqh")
    public fun projectOverwriteOption(`value`: SsisMigrationOverwriteOption) {
        val toBeMapped = Either.ofRight<String, SsisMigrationOverwriteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectOverwriteOption = mapped
    }

    /**
     * @param value The SSIS store type of source, only SSIS catalog is supported now in DMS
     */
    @JvmName("nguttvpeyrfdvtju")
    public suspend fun ssisStoreType(`value`: Either<String, SsisStoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssisStoreType = mapped
    }

    /**
     * @param value The SSIS store type of source, only SSIS catalog is supported now in DMS
     */
    @JvmName("inwygfytvpusigxi")
    public fun ssisStoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SsisStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssisStoreType = mapped
    }

    /**
     * @param value The SSIS store type of source, only SSIS catalog is supported now in DMS
     */
    @JvmName("ftkmjujrniraxlog")
    public fun ssisStoreType(`value`: SsisStoreType) {
        val toBeMapped = Either.ofRight<String, SsisStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssisStoreType = mapped
    }

    internal fun build(): SsisMigrationInfoArgs = SsisMigrationInfoArgs(
        environmentOverwriteOption = environmentOverwriteOption,
        projectOverwriteOption = projectOverwriteOption,
        ssisStoreType = ssisStoreType,
    )
}
