@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
 * @property azureApp Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
 * @property backupFileShare Backup file share information for all selected databases.
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source SQL Server
 * @property storageResourceId Fully qualified resourceId of storage
 * @property targetConnectionInfo Connection information for Azure SQL Database Managed Instance
 */
public data class ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs(
    public val azureApp: Output<AzureActiveDirectoryAppArgs>,
    public val backupFileShare: Output<FileShareArgs>? = null,
    public val selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val storageResourceId: Output<String>,
    public val targetConnectionInfo: Output<MiSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs.builder()
            .azureApp(azureApp.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupFileShare(backupFileShare?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageResourceId(storageResourceId.applyValue({ args0 -> args0 }))
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs].
 */
@PulumiTagMarker
public class ValidateMigrationInputSqlServerSqlMISyncTaskInputArgsBuilder internal constructor() {
    private var azureApp: Output<AzureActiveDirectoryAppArgs>? = null

    private var backupFileShare: Output<FileShareArgs>? = null

    private var selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var storageResourceId: Output<String>? = null

    private var targetConnectionInfo: Output<MiSqlConnectionInfoArgs>? = null

    /**
     * @param value Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("ihoevhfvvjfnqvhr")
    public suspend fun azureApp(`value`: Output<AzureActiveDirectoryAppArgs>) {
        this.azureApp = value
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("laxuvrakjlehuoeg")
    public suspend fun backupFileShare(`value`: Output<FileShareArgs>) {
        this.backupFileShare = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("awegekudkvsjjepq")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("ixtsbuyxfvqymktf")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlMIDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("fcabyyxyygpsjpfm")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for source SQL Server
     */
    @JvmName("tjlqmerhxdxbbnge")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Fully qualified resourceId of storage
     */
    @JvmName("edidtotoucpbpixd")
    public suspend fun storageResourceId(`value`: Output<String>) {
        this.storageResourceId = value
    }

    /**
     * @param value Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("abuyitnemqwkgfpu")
    public suspend fun targetConnectionInfo(`value`: Output<MiSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("gkokkqeyxjsgqavt")
    public suspend fun azureApp(`value`: AzureActiveDirectoryAppArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureApp = mapped
    }

    /**
     * @param argument Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("tuobrtwwageflonc")
    public suspend fun azureApp(argument: suspend AzureActiveDirectoryAppArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryAppArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureApp = mapped
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("bsbasembmlbpriww")
    public suspend fun backupFileShare(`value`: FileShareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFileShare = mapped
    }

    /**
     * @param argument Backup file share information for all selected databases.
     */
    @JvmName("mgpgvoghsehhyvin")
    public suspend fun backupFileShare(argument: suspend FileShareArgsBuilder.() -> Unit) {
        val toBeMapped = FileShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupFileShare = mapped
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("uyhohjjhvvtmhrix")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlMIDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("tianpmmtkvfabkmh")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("ltqmkjanqwanildv")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("wgqhvykrfxlnubrb")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("eyvfsonnirsnqdlm")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlMIDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Connection information for source SQL Server
     */
    @JvmName("dpdqixbbjlpbhndo")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source SQL Server
     */
    @JvmName("ckdgxmxrqwlbcjxn")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Fully qualified resourceId of storage
     */
    @JvmName("uqkebaxjoilmdyfx")
    public suspend fun storageResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageResourceId = mapped
    }

    /**
     * @param value Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("lcdpgbrpmvpkryyo")
    public suspend fun targetConnectionInfo(`value`: MiSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("fcnctakptqpxufgu")
    public suspend
    fun targetConnectionInfo(argument: suspend MiSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MiSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs =
        ValidateMigrationInputSqlServerSqlMISyncTaskInputArgs(
            azureApp = azureApp ?: throw PulumiNullFieldException("azureApp"),
            backupFileShare = backupFileShare,
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            storageResourceId = storageResourceId ?: throw PulumiNullFieldException("storageResourceId"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
