@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ValidateMongoDbTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that validates a migration between MongoDB data sources
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Describes how a MongoDB data migration should be performed
 * @property taskType Task type.
 * Expected value is 'Validate.MongoDb'.
 */
public data class ValidateMongoDbTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MongoDbMigrationSettingsArgs>? = null,
    public val taskType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ValidateMongoDbTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ValidateMongoDbTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.ValidateMongoDbTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ValidateMongoDbTaskPropertiesArgs].
 */
@PulumiTagMarker
public class ValidateMongoDbTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MongoDbMigrationSettingsArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("aqvobdhupbqlhvvb")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Describes how a MongoDB data migration should be performed
     */
    @JvmName("bbhslrwymhxflrwk")
    public suspend fun input(`value`: Output<MongoDbMigrationSettingsArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Validate.MongoDb'.
     */
    @JvmName("qguyamqinljdbotx")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("pkqhixavqcvarpka")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("thxdavcuxylndifr")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Describes how a MongoDB data migration should be performed
     */
    @JvmName("pmbetbgtloiojiae")
    public suspend fun input(`value`: MongoDbMigrationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Describes how a MongoDB data migration should be performed
     */
    @JvmName("gdaaeatclfnbkyld")
    public suspend fun input(argument: suspend MongoDbMigrationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDbMigrationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Validate.MongoDb'.
     */
    @JvmName("beabulhywtauvgfn")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): ValidateMongoDbTaskPropertiesArgs = ValidateMongoDbTaskPropertiesArgs(
        clientData = clientData,
        input = input,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
    )
}
