@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that validates a migration for Oracle to Azure Database for PostgreSQL for online migrations
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
 * @property taskType Task type.
 * Expected value is 'Validate.Oracle.AzureDbPostgreSql.Sync'.
 */
public data class ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs].
 */
@PulumiTagMarker
public class ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("axfibvpkswjhlrkr")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
     */
    @JvmName("njdbxnmcvemlqhbc")
    public suspend fun input(`value`: Output<MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Validate.Oracle.AzureDbPostgreSql.Sync'.
     */
    @JvmName("uudaxuaonfyciahl")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("pdhsnxkmtvfsumev")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("ofwqcqkuwgpxmccm")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
     */
    @JvmName("lofhqnehcaohmxhv")
    public suspend fun input(`value`: MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
     */
    @JvmName("soelcvfwpnvxhqnv")
    public suspend
    fun input(argument: suspend MigrateOracleAzureDbPostgreSqlSyncTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateOracleAzureDbPostgreSqlSyncTaskInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Validate.Oracle.AzureDbPostgreSql.Sync'.
     */
    @JvmName("vqfyiafqxwagnnnq")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        ValidateOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
