@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that validates Oracle database connection
 * @property databases List of schemas on source server
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Version of the source server
 * @property validationErrors Validation errors associated with the task
 */
public data class ConnectToSourceOracleSyncTaskOutputResponse(
    public val databases: List<String>,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceOracleSyncTaskOutputResponse):
            ConnectToSourceOracleSyncTaskOutputResponse = ConnectToSourceOracleSyncTaskOutputResponse(
            databases = javaType.databases().map({ args0 -> args0 }),
            sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
            sourceServerVersion = javaType.sourceServerVersion(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
