@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Input for the task that validates connection to Azure Database for MySQL and target server requirements
 * @property isOfflineMigration Flag for whether or not the migration is offline
 * @property sourceConnectionInfo Connection information for source MySQL server
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL server
 */
public data class ConnectToTargetAzureDbForMySqlTaskInputResponse(
    public val isOfflineMigration: Boolean? = null,
    public val sourceConnectionInfo: MySqlConnectionInfoResponse,
    public val targetConnectionInfo: MySqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetAzureDbForMySqlTaskInputResponse):
            ConnectToTargetAzureDbForMySqlTaskInputResponse =
            ConnectToTargetAzureDbForMySqlTaskInputResponse(
                isOfflineMigration = javaType.isOfflineMigration().map({ args0 -> args0 }).orElse(null),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
