@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Input for the task that validates connection to Azure SQL Database Managed Instance.
 * @property collectAgentJobs Flag for whether to collect agent jobs from target SQL MI server.
 * @property collectLogins Flag for whether to collect logins from target SQL MI server.
 * @property targetConnectionInfo Connection information for target SQL Server
 * @property validateSsisCatalogOnly Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
 */
public data class ConnectToTargetSqlMITaskInputResponse(
    public val collectAgentJobs: Boolean? = null,
    public val collectLogins: Boolean? = null,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
    public val validateSsisCatalogOnly: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlMITaskInputResponse):
            ConnectToTargetSqlMITaskInputResponse = ConnectToTargetSqlMITaskInputResponse(
            collectAgentJobs = javaType.collectAgentJobs().map({ args0 -> args0 }).orElse(null),
            collectLogins = javaType.collectLogins().map({ args0 -> args0 }).orElse(null),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            validateSsisCatalogOnly = javaType.validateSsisCatalogOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
