@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Table properties
 * @property hasRows Indicates whether table is empty or not
 * @property name Schema-qualified name of the table
 */
public data class DatabaseTableResponse(
    public val hasRows: Boolean,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DatabaseTableResponse):
            DatabaseTableResponse = DatabaseTableResponse(
            hasRows = javaType.hasRows(),
            name = javaType.name(),
        )
    }
}
