@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Error details
 * @property code Error code.
 * @property message Error message.
 */
public data class ErrorInfoResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ErrorInfoResponse):
            ErrorInfoResponse = ErrorInfoResponse(
            code = javaType.code(),
            message = javaType.message(),
        )
    }
}
