@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A project resource
 * @property creationTime UTC Date and time when project was created
 * @property databasesInfo List of DatabaseInfo
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The project's provisioning state
 * @property sourceConnectionInfo Information for connecting to source
 * @property sourcePlatform Source platform for the project
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property targetConnectionInfo Information for connecting to target
 * @property targetPlatform Target platform for the project
 * @property type Resource type.
 */
public data class GetProjectResult(
    public val creationTime: String,
    public val databasesInfo: List<DatabaseInfoResponse>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sourceConnectionInfo: Any? = null,
    public val sourcePlatform: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetConnectionInfo: Any? = null,
    public val targetPlatform: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetProjectResult):
            GetProjectResult = GetProjectResult(
            creationTime = javaType.creationTime(),
            databasesInfo = javaType.databasesInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseInfoResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceConnectionInfo = javaType.sourceConnectionInfo().map({ args0 -> args0 }).orElse(null),
            sourcePlatform = javaType.sourcePlatform(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetConnectionInfo = javaType.targetConnectionInfo().map({ args0 -> args0 }).orElse(null),
            targetPlatform = javaType.targetPlatform(),
            type = javaType.type(),
        )
    }
}
