@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A SQL Migration Service.
 * @property id
 * @property integrationRuntimeState Current state of the Integration runtime.
 * @property location
 * @property name
 * @property provisioningState Provisioning state to track the async operation status.
 * @property systemData
 * @property tags
 * @property type
 */
public data class GetSqlMigrationServiceResult(
    public val id: String,
    public val integrationRuntimeState: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetSqlMigrationServiceResult):
            GetSqlMigrationServiceResult = GetSqlMigrationServiceResult(
            id = javaType.id(),
            integrationRuntimeState = javaType.integrationRuntimeState(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
