@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Output of the task that collects user tables for the given list of databases
 * @property databasesToTables Mapping from database name to list of tables
 * @property id Result identifier
 * @property validationErrors Validation errors
 */
public data class GetUserTablesMySqlTaskOutputResponse(
    public val databasesToTables: Map<String, List<DatabaseTableResponse>>,
    public val id: String,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesMySqlTaskOutputResponse):
            GetUserTablesMySqlTaskOutputResponse = GetUserTablesMySqlTaskOutputResponse(
            databasesToTables = javaType.databasesToTables().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseTableResponse.Companion.toKotlin(args0)
                        })
                    }),
                )
            }).toMap(),
            id = javaType.id(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
