@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that gets the list of tables for a provided list of PostgreSQL databases.
 * @property connectionInfo Information for connecting to PostgreSQL source
 * @property selectedDatabases List of PostgreSQL databases for which to collect tables
 */
public data class GetUserTablesPostgreSqlTaskInputResponse(
    public val connectionInfo: PostgreSqlConnectionInfoResponse,
    public val selectedDatabases: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesPostgreSqlTaskInputResponse):
            GetUserTablesPostgreSqlTaskInputResponse = GetUserTablesPostgreSqlTaskInputResponse(
            connectionInfo = javaType.connectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.PostgreSqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            selectedDatabases = javaType.selectedDatabases().map({ args0 -> args0 }),
        )
    }
}
