@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source Oracle
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL
 */
public data class MigrateOracleAzureDbPostgreSqlSyncTaskInputResponse(
    public val selectedDatabases: List<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse>,
    public val sourceConnectionInfo: OracleConnectionInfoResponse,
    public val targetConnectionInfo: PostgreSqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateOracleAzureDbPostgreSqlSyncTaskInputResponse):
            MigrateOracleAzureDbPostgreSqlSyncTaskInputResponse =
            MigrateOracleAzureDbPostgreSqlSyncTaskInputResponse(
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.OracleConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.PostgreSqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
