@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cdcDeleteCounter Number of applied deletes
 * @property cdcInsertCounter Number of applied inserts
 * @property cdcUpdateCounter Number of applied updates
 * @property dataErrorsCounter Number of data errors occurred
 * @property databaseName Name of the database
 * @property fullLoadEndedOn Full load end time
 * @property fullLoadEstFinishTime Estimate to finish full load
 * @property fullLoadStartedOn Full load start time
 * @property fullLoadTotalRows Number of rows applied in full load
 * @property id Result identifier
 * @property lastModifiedTime Last modified time on target
 * @property resultType Result type
 * Expected value is 'TableLevelOutput'.
 * @property state Current state of the table migration
 * @property tableName Name of the table
 * @property totalChangesApplied Total number of applied changes
 */
public data class MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse(
    public val cdcDeleteCounter: Double,
    public val cdcInsertCounter: Double,
    public val cdcUpdateCounter: Double,
    public val dataErrorsCounter: Double,
    public val databaseName: String,
    public val fullLoadEndedOn: String,
    public val fullLoadEstFinishTime: String,
    public val fullLoadStartedOn: String,
    public val fullLoadTotalRows: Double,
    public val id: String,
    public val lastModifiedTime: String,
    public val resultType: String,
    public val state: String,
    public val tableName: String,
    public val totalChangesApplied: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse):
            MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse =
            MigrateSqlServerSqlDbSyncTaskOutputTableLevelResponse(
                cdcDeleteCounter = javaType.cdcDeleteCounter(),
                cdcInsertCounter = javaType.cdcInsertCounter(),
                cdcUpdateCounter = javaType.cdcUpdateCounter(),
                dataErrorsCounter = javaType.dataErrorsCounter(),
                databaseName = javaType.databaseName(),
                fullLoadEndedOn = javaType.fullLoadEndedOn(),
                fullLoadEstFinishTime = javaType.fullLoadEstFinishTime(),
                fullLoadStartedOn = javaType.fullLoadStartedOn(),
                fullLoadTotalRows = javaType.fullLoadTotalRows(),
                id = javaType.id(),
                lastModifiedTime = javaType.lastModifiedTime(),
                resultType = javaType.resultType(),
                state = javaType.state(),
                tableName = javaType.tableName(),
                totalChangesApplied = javaType.totalChangesApplied(),
            )
    }
}
