@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property activeBackupSets Backup sets that are currently active (Either being uploaded or getting restored)
 * @property containerName Name of container created in the Azure Storage account where backups are copied to
 * @property endedOn Database migration end time
 * @property errorPrefix prefix string to use for querying errors for this database
 * @property exceptionsAndWarnings Migration exceptions and warnings
 * @property fullBackupSetInfo Details of full backup set
 * @property id Result identifier
 * @property isFullBackupRestored Whether full backup has been applied to the target database or not
 * @property lastRestoredBackupSetInfo Last applied backup set information
 * @property migrationState Current state of database
 * @property resultType Result type
 * Expected value is 'DatabaseLevelOutput'.
 * @property sourceDatabaseName Name of the database
 * @property startedOn Database migration start time
 */
public data class MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse(
    public val activeBackupSets: List<BackupSetInfoResponse>,
    public val containerName: String,
    public val endedOn: String,
    public val errorPrefix: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val fullBackupSetInfo: BackupSetInfoResponse,
    public val id: String,
    public val isFullBackupRestored: Boolean,
    public val lastRestoredBackupSetInfo: BackupSetInfoResponse,
    public val migrationState: String,
    public val resultType: String,
    public val sourceDatabaseName: String,
    public val startedOn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse):
            MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse =
            MigrateSqlServerSqlMISyncTaskOutputDatabaseLevelResponse(
                activeBackupSets = javaType.activeBackupSets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.BackupSetInfoResponse.Companion.toKotlin(args0)
                    })
                }),
                containerName = javaType.containerName(),
                endedOn = javaType.endedOn(),
                errorPrefix = javaType.errorPrefix(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                fullBackupSetInfo = javaType.fullBackupSetInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.BackupSetInfoResponse.Companion.toKotlin(args0)
                }),
                id = javaType.id(),
                isFullBackupRestored = javaType.isFullBackupRestored(),
                lastRestoredBackupSetInfo = javaType.lastRestoredBackupSetInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.BackupSetInfoResponse.Companion.toKotlin(args0)
                }),
                migrationState = javaType.migrationState(),
                resultType = javaType.resultType(),
                sourceDatabaseName = javaType.sourceDatabaseName(),
                startedOn = javaType.startedOn(),
            )
    }
}
