@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property databaseName Name of the database
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration exceptions and warnings
 * @property id Result identifier
 * @property message Migration progress message
 * @property resultType Result type
 * Expected value is 'DatabaseLevelOutput'.
 * @property sizeMB Size of the database in megabytes
 * @property stage Current stage of migration
 * @property startedOn Migration start time
 * @property state Current state of migration
 */
public data class MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse(
    public val databaseName: String,
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val message: String,
    public val resultType: String,
    public val sizeMB: Double,
    public val stage: String,
    public val startedOn: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse):
            MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse =
            MigrateSqlServerSqlMITaskOutputDatabaseLevelResponse(
                databaseName = javaType.databaseName(),
                endedOn = javaType.endedOn(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                message = javaType.message(),
                resultType = javaType.resultType(),
                sizeMB = javaType.sizeMB(),
                stage = javaType.stage(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
            )
    }
}
