@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endedOn Login migration end time
 * @property exceptionsAndWarnings Login migration errors and warnings per login
 * @property id Result identifier
 * @property loginName Login name.
 * @property message Login migration progress message
 * @property resultType Result type
 * Expected value is 'LoginLevelOutput'.
 * @property stage Current stage of login
 * @property startedOn Login migration start time
 * @property state Current state of login
 */
public data class MigrateSqlServerSqlMITaskOutputLoginLevelResponse(
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val loginName: String,
    public val message: String,
    public val resultType: String,
    public val stage: String,
    public val startedOn: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlMITaskOutputLoginLevelResponse):
            MigrateSqlServerSqlMITaskOutputLoginLevelResponse =
            MigrateSqlServerSqlMITaskOutputLoginLevelResponse(
                endedOn = javaType.endedOn(),
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                loginName = javaType.loginName(),
                message = javaType.message(),
                resultType = javaType.resultType(),
                stage = javaType.stage(),
                startedOn = javaType.startedOn(),
                state = javaType.state(),
            )
    }
}
