@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration exceptions and warnings
 * @property folderName Name of the folder
 * @property id Result identifier
 * @property message Migration progress message
 * @property projectName Name of the project
 * @property resultType Result type
 * Expected value is 'SsisProjectLevelOutput'.
 * @property stage Stage of SSIS migration.
 * @property startedOn Migration start time
 * @property state Current state of migration
 */
public data class MigrateSsisTaskOutputProjectLevelResponse(
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val folderName: String,
    public val id: String,
    public val message: String,
    public val projectName: String,
    public val resultType: String,
    public val stage: String,
    public val startedOn: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSsisTaskOutputProjectLevelResponse):
            MigrateSsisTaskOutputProjectLevelResponse = MigrateSsisTaskOutputProjectLevelResponse(
            endedOn = javaType.endedOn(),
            exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
            folderName = javaType.folderName(),
            id = javaType.id(),
            message = javaType.message(),
            projectName = javaType.projectName(),
            resultType = javaType.resultType(),
            stage = javaType.stage(),
            startedOn = javaType.startedOn(),
            state = javaType.state(),
        )
    }
}
