@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes how a MongoDB data migration should be performed
 * @property boostRUs The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
 * @property databases The databases on the source cluster to migrate to the target. The keys are the names of the databases.
 * @property replication Describes how changes will be replicated from the source to the target. The default is OneTime.
 * @property source Settings used to connect to the source cluster
 * @property target Settings used to connect to the target cluster
 * @property throttling Settings used to limit the resource usage of the migration
 */
public data class MongoDbMigrationSettingsResponse(
    public val boostRUs: Int? = null,
    public val databases: Map<String, MongoDbDatabaseSettingsResponse>,
    public val replication: String? = null,
    public val source: MongoDbConnectionInfoResponse,
    public val target: MongoDbConnectionInfoResponse,
    public val throttling: MongoDbThrottlingSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbMigrationSettingsResponse):
            MongoDbMigrationSettingsResponse = MongoDbMigrationSettingsResponse(
            boostRUs = javaType.boostRUs().map({ args0 -> args0 }).orElse(null),
            databases = javaType.databases().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbDatabaseSettingsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            replication = javaType.replication().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            target = javaType.target().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            throttling = javaType.throttling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbThrottlingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
