@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a field reference within a MongoDB shard key
 * @property name The name of the field
 * @property order The field ordering
 */
public data class MongoDbShardKeyFieldResponse(
    public val name: String,
    public val order: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbShardKeyFieldResponse):
            MongoDbShardKeyFieldResponse = MongoDbShardKeyFieldResponse(
            name = javaType.name(),
            order = javaType.order(),
        )
    }
}
