@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a MongoDB shard key
 * @property fields The fields within the shard key
 * @property isUnique Whether the shard key is unique
 */
public data class MongoDbShardKeyInfoResponse(
    public val fields: List<MongoDbShardKeyFieldResponse>,
    public val isUnique: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbShardKeyInfoResponse):
            MongoDbShardKeyInfoResponse = MongoDbShardKeyInfoResponse(
            fields = javaType.fields().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbShardKeyFieldResponse.Companion.toKotlin(args0)
                })
            }),
            isUnique = javaType.isUnique(),
        )
    }
}
