@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Database migration errors for online migration
 * @property eventText Event text.
 * @property eventTypeString Event type.
 * @property timestampString String value of timestamp.
 */
public data class SyncMigrationDatabaseErrorEventResponse(
    public val eventText: String,
    public val eventTypeString: String,
    public val timestampString: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SyncMigrationDatabaseErrorEventResponse):
            SyncMigrationDatabaseErrorEventResponse = SyncMigrationDatabaseErrorEventResponse(
            eventText = javaType.eventText(),
            eventTypeString = javaType.eventTypeString(),
            timestampString = javaType.timestampString(),
        )
    }
}
