@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for task that validates migration input for SQL sync migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source SQL server
 * @property targetConnectionInfo Information for connecting to target
 */
public data class ValidateSyncMigrationInputSqlServerTaskInputResponse(
    public val selectedDatabases: List<MigrateSqlServerSqlDbSyncDatabaseInputResponse>,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateSyncMigrationInputSqlServerTaskInputResponse):
            ValidateSyncMigrationInputSqlServerTaskInputResponse =
            ValidateSyncMigrationInputSqlServerTaskInputResponse(
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSqlServerSqlDbSyncDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
