@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description about the errors happen while performing migration validation
 * @property severity Severity of the error
 * @property text Error Text
 */
public data class ValidationErrorResponse(
    public val severity: String? = null,
    public val text: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidationErrorResponse):
            ValidationErrorResponse = ValidationErrorResponse(
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            text = javaType.text().map({ args0 -> args0 }).orElse(null),
        )
    }
}
