@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupInstanceResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupInstanceResponse.Companion.toKotlin as backupInstanceResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BackupInstance].
 */
@PulumiTagMarker
public class BackupInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupInstanceArgs = BackupInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupInstanceArgsBuilder.() -> Unit) {
        val builder = BackupInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupInstance {
        val builtJavaResource =
            com.pulumi.azurenative.dataprotection.BackupInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupInstance(builtJavaResource)
    }
}

/**
 * BackupInstance Resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### Create BackupInstance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupInstance = new AzureNative.DataProtection.BackupInstance("backupInstance", new()
 *     {
 *         BackupInstanceName = "testInstance1",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupInstanceArgs
 *         {
 *             DataSourceInfo = new AzureNative.DataProtection.Inputs.DatasourceArgs
 *             {
 *                 DatasourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ObjectType = "Datasource",
 *                 ResourceID = "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb",
 *                 ResourceLocation = "",
 *                 ResourceName = "testdb",
 *                 ResourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ResourceUri = "",
 *             },
 *             DataSourceSetInfo = new AzureNative.DataProtection.Inputs.DatasourceSetArgs
 *             {
 *                 DatasourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ObjectType = "DatasourceSet",
 *                 ResourceID = "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest",
 *                 ResourceLocation = "",
 *                 ResourceName = "viveksipgtest",
 *                 ResourceType = "Microsoft.DBforPostgreSQL/servers",
 *                 ResourceUri = "",
 *             },
 *             DatasourceAuthCredentials =
 *             {
 *                 { "objectType", "SecretStoreBasedAuthCredentials" },
 *                 { "secretStoreResource", new AzureNative.DataProtection.Inputs.SecretStoreResourceArgs
 *                 {
 *                     SecretStoreType = "AzureKeyVault",
 *                     Uri = "https://samplevault.vault.azure.net/secrets/credentials",
 *                 } },
 *             },
 *             FriendlyName = "harshitbi2",
 *             ObjectType = "BackupInstance",
 *             PolicyInfo = new AzureNative.DataProtection.Inputs.PolicyInfoArgs
 *             {
 *                 PolicyId = "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1",
 *                 PolicyParameters = new AzureNative.DataProtection.Inputs.PolicyParametersArgs
 *                 {
 *                     DataStoreParametersList = new[]
 *                     {
 *                         {
 *                             { "dataStoreType", "OperationalStore" },
 *                             { "objectType", "AzureOperationalStoreParameters" },
 *                             { "resourceGroupId", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest" },
 *                         },
 *                     },
 *                 },
 *             },
 *             ValidationType = "ShallowValidation",
 *         },
 *         ResourceGroupName = "000pikumar",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "PratikPrivatePreviewVault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupInstance(ctx, "backupInstance", &dataprotection.BackupInstanceArgs{
 * BackupInstanceName: pulumi.String("testInstance1"),
 * Properties: dataprotection.BackupInstanceResponse{
 * DataSourceInfo: &dataprotection.DatasourceArgs{
 * DatasourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ObjectType: pulumi.String("Datasource"),
 * ResourceID: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb"),
 * ResourceLocation: pulumi.String(""),
 * ResourceName: pulumi.String("testdb"),
 * ResourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ResourceUri: pulumi.String(""),
 * },
 * DataSourceSetInfo: &dataprotection.DatasourceSetArgs{
 * DatasourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ObjectType: pulumi.String("DatasourceSet"),
 * ResourceID: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest"),
 * ResourceLocation: pulumi.String(""),
 * ResourceName: pulumi.String("viveksipgtest"),
 * ResourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers"),
 * ResourceUri: pulumi.String(""),
 * },
 * DatasourceAuthCredentials: interface{}{
 * ObjectType: pulumi.String("SecretStoreBasedAuthCredentials"),
 * SecretStoreResource: &dataprotection.SecretStoreResourceArgs{
 * SecretStoreType: pulumi.String("AzureKeyVault"),
 * Uri: pulumi.String("https://samplevault.vault.azure.net/secrets/credentials"),
 * },
 * },
 * FriendlyName: pulumi.String("harshitbi2"),
 * ObjectType: pulumi.String("BackupInstance"),
 * PolicyInfo: interface{}{
 * PolicyId: pulumi.String("/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1"),
 * PolicyParameters: interface{}{
 * DataStoreParametersList: []dataprotection.AzureOperationalStoreParametersArgs{
 * {
 * DataStoreType: pulumi.String("OperationalStore"),
 * ObjectType: pulumi.String("AzureOperationalStoreParameters"),
 * ResourceGroupId: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest"),
 * },
 * },
 * },
 * },
 * ValidationType: pulumi.String("ShallowValidation"),
 * },
 * ResourceGroupName: pulumi.String("000pikumar"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("PratikPrivatePreviewVault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupInstance;
 * import com.pulumi.azurenative.dataprotection.BackupInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupInstance = new BackupInstance("backupInstance", BackupInstanceArgs.builder()
 *             .backupInstanceName("testInstance1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("dataSourceInfo", Map.ofEntries(
 *                     Map.entry("datasourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("objectType", "Datasource"),
 *                     Map.entry("resourceID", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb"),
 *                     Map.entry("resourceLocation", ""),
 *                     Map.entry("resourceName", "testdb"),
 *                     Map.entry("resourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("resourceUri", "")
 *                 )),
 *                 Map.entry("dataSourceSetInfo", Map.ofEntries(
 *                     Map.entry("datasourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("objectType", "DatasourceSet"),
 *                     Map.entry("resourceID", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest"),
 *                     Map.entry("resourceLocation", ""),
 *                     Map.entry("resourceName", "viveksipgtest"),
 *                     Map.entry("resourceType", "Microsoft.DBforPostgreSQL/servers"),
 *                     Map.entry("resourceUri", "")
 *                 )),
 *                 Map.entry("datasourceAuthCredentials", Map.ofEntries(
 *                     Map.entry("objectType", "SecretStoreBasedAuthCredentials"),
 *                     Map.entry("secretStoreResource", Map.ofEntries(
 *                         Map.entry("secretStoreType", "AzureKeyVault"),
 *                         Map.entry("uri", "https://samplevault.vault.azure.net/secrets/credentials")
 *                     ))
 *                 )),
 *                 Map.entry("friendlyName", "harshitbi2"),
 *                 Map.entry("objectType", "BackupInstance"),
 *                 Map.entry("policyInfo", Map.ofEntries(
 *                     Map.entry("policyId", "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1"),
 *                     Map.entry("policyParameters", Map.of("dataStoreParametersList", Map.ofEntries(
 *                         Map.entry("dataStoreType", "OperationalStore"),
 *                         Map.entry("objectType", "AzureOperationalStoreParameters"),
 *                         Map.entry("resourceGroupId", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest")
 *                     )))
 *                 )),
 *                 Map.entry("validationType", "ShallowValidation")
 *             ))
 *             .resourceGroupName("000pikumar")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("PratikPrivatePreviewVault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:BackupInstance harshitbi2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}
 * ```
 */
public class BackupInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.dataprotection.BackupInstance,
) : KotlinCustomResource(javaResource, BackupInstanceMapper) {
    /**
     * Proxy Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * BackupInstanceResource properties
     */
    public val properties: Output<BackupInstanceResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                backupInstanceResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Proxy Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Proxy Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BackupInstanceMapper : ResourceMapper<BackupInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dataprotection.BackupInstance::class == javaResource::class

    override fun map(javaResource: Resource): BackupInstance = BackupInstance(
        javaResource as
            com.pulumi.azurenative.dataprotection.BackupInstance,
    )
}

/**
 * @see [BackupInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupInstance].
 */
public suspend fun backupInstance(
    name: String,
    block: suspend BackupInstanceResourceBuilder.() -> Unit,
): BackupInstance {
    val builder = BackupInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupInstance(name: String): BackupInstance {
    val builder = BackupInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
