@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.BackupVaultArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.DppIdentityDetailsArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.DppIdentityDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Backup Vault Resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### Create BackupVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupVault = new AzureNative.DataProtection.BackupVault("backupVault", new()
 *     {
 *         Identity = new AzureNative.DataProtection.Inputs.DppIdentityDetailsArgs
 *         {
 *             Type = "None",
 *         },
 *         Location = "WestUS",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupVaultArgs
 *         {
 *             MonitoringSettings = new AzureNative.DataProtection.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.DataProtection.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = "Enabled",
 *                 },
 *             },
 *             StorageSettings = new[]
 *             {
 *                 new AzureNative.DataProtection.Inputs.StorageSettingArgs
 *                 {
 *                     DatastoreType = "VaultStore",
 *                     Type = "LocallyRedundant",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupVault(ctx, "backupVault", &dataprotection.BackupVaultArgs{
 * Identity: &dataprotection.DppIdentityDetailsArgs{
 * Type: pulumi.String("None"),
 * },
 * Location: pulumi.String("WestUS"),
 * Properties: dataprotection.BackupVaultResponse{
 * MonitoringSettings: interface{}{
 * AzureMonitorAlertSettings: &dataprotection.AzureMonitorAlertSettingsArgs{
 * AlertsForAllJobFailures: pulumi.String("Enabled"),
 * },
 * },
 * StorageSettings: dataprotection.StorageSettingArray{
 * &dataprotection.StorageSettingArgs{
 * DatastoreType: pulumi.String("VaultStore"),
 * Type: pulumi.String("LocallyRedundant"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("swaggerExample"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupVault;
 * import com.pulumi.azurenative.dataprotection.BackupVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupVault = new BackupVault("backupVault", BackupVaultArgs.builder()
 *             .identity(Map.of("type", "None"))
 *             .location("WestUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoringSettings", Map.of("azureMonitorAlertSettings", Map.of("alertsForAllJobFailures", "Enabled"))),
 *                 Map.entry("storageSettings", Map.ofEntries(
 *                     Map.entry("datastoreType", "VaultStore"),
 *                     Map.entry("type", "LocallyRedundant")
 *                 ))
 *             ))
 *             .resourceGroupName("SampleResourceGroup")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### Create BackupVault With MSI
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupVault = new AzureNative.DataProtection.BackupVault("backupVault", new()
 *     {
 *         Identity = new AzureNative.DataProtection.Inputs.DppIdentityDetailsArgs
 *         {
 *             Type = "systemAssigned",
 *         },
 *         Location = "WestUS",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupVaultArgs
 *         {
 *             MonitoringSettings = new AzureNative.DataProtection.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.DataProtection.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = "Enabled",
 *                 },
 *             },
 *             StorageSettings = new[]
 *             {
 *                 new AzureNative.DataProtection.Inputs.StorageSettingArgs
 *                 {
 *                     DatastoreType = "VaultStore",
 *                     Type = "LocallyRedundant",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupVault(ctx, "backupVault", &dataprotection.BackupVaultArgs{
 * Identity: &dataprotection.DppIdentityDetailsArgs{
 * Type: pulumi.String("systemAssigned"),
 * },
 * Location: pulumi.String("WestUS"),
 * Properties: dataprotection.BackupVaultResponse{
 * MonitoringSettings: interface{}{
 * AzureMonitorAlertSettings: &dataprotection.AzureMonitorAlertSettingsArgs{
 * AlertsForAllJobFailures: pulumi.String("Enabled"),
 * },
 * },
 * StorageSettings: dataprotection.StorageSettingArray{
 * &dataprotection.StorageSettingArgs{
 * DatastoreType: pulumi.String("VaultStore"),
 * Type: pulumi.String("LocallyRedundant"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("swaggerExample"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupVault;
 * import com.pulumi.azurenative.dataprotection.BackupVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupVault = new BackupVault("backupVault", BackupVaultArgs.builder()
 *             .identity(Map.of("type", "systemAssigned"))
 *             .location("WestUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoringSettings", Map.of("azureMonitorAlertSettings", Map.of("alertsForAllJobFailures", "Enabled"))),
 *                 Map.entry("storageSettings", Map.ofEntries(
 *                     Map.entry("datastoreType", "VaultStore"),
 *                     Map.entry("type", "LocallyRedundant")
 *                 ))
 *             ))
 *             .resourceGroupName("SampleResourceGroup")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:BackupVault swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}
 * ```
 * @property eTag Optional ETag.
 * @property identity Input Managed Identity Details
 * @property location Resource location.
 * @property properties BackupVaultResource properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vaultName The name of the backup vault.
 */
public data class BackupVaultArgs(
    public val eTag: Output<String>? = null,
    public val identity: Output<DppIdentityDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val properties:
    Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.BackupVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.BackupVaultArgs =
        com.pulumi.azurenative.dataprotection.BackupVaultArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupVaultArgs].
 */
@PulumiTagMarker
public class BackupVaultArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var identity: Output<DppIdentityDetailsArgs>? = null

    private var location: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("jpwnqsogoeovfgvc")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Input Managed Identity Details
     */
    @JvmName("lmyqvgiknjbqvncn")
    public suspend fun identity(`value`: Output<DppIdentityDetailsArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qekjkcuikqjguwmi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value BackupVaultResource properties
     */
    @JvmName("hqkvcrcenschuhpw")
    public suspend
    fun properties(`value`: Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("giijbqaunlrbjfjn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("siutilkynpaltufq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("xwntobfgewajmpwq")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("daaoghikvvpuuhkn")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Input Managed Identity Details
     */
    @JvmName("kcbmggjrutegrkqm")
    public suspend fun identity(`value`: DppIdentityDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Input Managed Identity Details
     */
    @JvmName("lxgvrxfdcjvnfdkl")
    public suspend fun identity(argument: suspend DppIdentityDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = DppIdentityDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("oychncixlrspkrcs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value BackupVaultResource properties
     */
    @JvmName("pfqypxtyftlgpvey")
    public suspend
    fun properties(`value`: com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument BackupVaultResource properties
     */
    @JvmName("fiulqpcgautnsumq")
    public suspend
    fun properties(argument: suspend com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupVaultArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("daoweaumjtsabsdu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pdobyhjloobhgeph")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iyjijjxchroymkvj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("kofbfqskujnagjju")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): BackupVaultArgs = BackupVaultArgs(
        eTag = eTag,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
