@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardProxyBaseResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardProxyBaseResponse.Companion.toKotlin as resourceGuardProxyBaseResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DppResourceGuardProxy].
 */
@PulumiTagMarker
public class DppResourceGuardProxyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DppResourceGuardProxyArgs = DppResourceGuardProxyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DppResourceGuardProxyArgsBuilder.() -> Unit) {
        val builder = DppResourceGuardProxyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DppResourceGuardProxy {
        val builtJavaResource =
            com.pulumi.azurenative.dataprotection.DppResourceGuardProxy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DppResourceGuardProxy(builtJavaResource)
    }
}

/**
 * ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
 * Azure REST API version: 2023-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### Create ResourceGuardProxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dppResourceGuardProxy = new AzureNative.DataProtection.DppResourceGuardProxy("dppResourceGuardProxy", new()
 *     {
 *         Properties = new AzureNative.DataProtection.Inputs.ResourceGuardProxyBaseArgs
 *         {
 *             ResourceGuardResourceId = "/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource",
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardProxyName = "swaggerExample",
 *         VaultName = "sampleVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataprotection.NewDppResourceGuardProxy(ctx, "dppResourceGuardProxy", &dataprotection.DppResourceGuardProxyArgs{
 * 			Properties: &dataprotection.ResourceGuardProxyBaseArgs{
 * 				ResourceGuardResourceId: pulumi.String("/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource"),
 * 			},
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardProxyName: pulumi.String("swaggerExample"),
 * 			VaultName:              pulumi.String("sampleVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.DppResourceGuardProxy;
 * import com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dppResourceGuardProxy = new DppResourceGuardProxy("dppResourceGuardProxy", DppResourceGuardProxyArgs.builder()
 *             .properties(Map.of("resourceGuardResourceId", "/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource"))
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardProxyName("swaggerExample")
 *             .vaultName("sampleVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:DppResourceGuardProxy swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}
 * ```
 */
public class DppResourceGuardProxy internal constructor(
    override val javaResource: com.pulumi.azurenative.dataprotection.DppResourceGuardProxy,
) : KotlinCustomResource(javaResource, DppResourceGuardProxyMapper) {
    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ResourceGuardProxyBaseResource properties
     */
    public val properties: Output<ResourceGuardProxyBaseResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceGuardProxyBaseResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DppResourceGuardProxyMapper : ResourceMapper<DppResourceGuardProxy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dataprotection.DppResourceGuardProxy::class == javaResource::class

    override fun map(javaResource: Resource): DppResourceGuardProxy =
        DppResourceGuardProxy(
            javaResource as
                com.pulumi.azurenative.dataprotection.DppResourceGuardProxy,
        )
}

/**
 * @see [DppResourceGuardProxy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DppResourceGuardProxy].
 */
public suspend fun dppResourceGuardProxy(
    name: String,
    block: suspend DppResourceGuardProxyResourceBuilder.() -> Unit,
): DppResourceGuardProxy {
    val builder = DppResourceGuardProxyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DppResourceGuardProxy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dppResourceGuardProxy(name: String): DppResourceGuardProxy {
    val builder = DppResourceGuardProxyResourceBuilder()
    builder.name(name)
    return builder.build()
}
