@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of soft delete
 */
public enum class SoftDeleteState(
    public val javaValue: com.pulumi.azurenative.dataprotection.enums.SoftDeleteState,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.enums.SoftDeleteState> {
    /**
     * Soft Delete is turned off for the BackupVault
     */
    Off(com.pulumi.azurenative.dataprotection.enums.SoftDeleteState.Off),

    /**
     * Soft Delete is enabled for the BackupVault but can be turned off
     */
    On(com.pulumi.azurenative.dataprotection.enums.SoftDeleteState.On),

    /**
     * Soft Delete is permanently enabled for the BackupVault and the setting cannot be changed
     */
    AlwaysOn(com.pulumi.azurenative.dataprotection.enums.SoftDeleteState.AlwaysOn),
    ;

    override fun toJava(): com.pulumi.azurenative.dataprotection.enums.SoftDeleteState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.enums.SoftDeleteState):
            SoftDeleteState = SoftDeleteState.values().first { it.javaValue == javaType }
    }
}
