@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.BlobBackupDatasourceParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters to be used during configuration of backup of blobs
 * @property containersList List of containers to be backed up during configuration of backup of blobs
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'BlobBackupDatasourceParameters'.
 */
public data class BlobBackupDatasourceParametersArgs(
    public val containersList: Output<List<String>>,
    public val objectType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.BlobBackupDatasourceParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.dataprotection.inputs.BlobBackupDatasourceParametersArgs =
        com.pulumi.azurenative.dataprotection.inputs.BlobBackupDatasourceParametersArgs.builder()
            .containersList(containersList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobBackupDatasourceParametersArgs].
 */
@PulumiTagMarker
public class BlobBackupDatasourceParametersArgsBuilder internal constructor() {
    private var containersList: Output<List<String>>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value List of containers to be backed up during configuration of backup of blobs
     */
    @JvmName("biqlnapwyppxjfqc")
    public suspend fun containersList(`value`: Output<List<String>>) {
        this.containersList = value
    }

    @JvmName("biprjjspkrdtqddu")
    public suspend fun containersList(vararg values: Output<String>) {
        this.containersList = Output.all(values.asList())
    }

    /**
     * @param values List of containers to be backed up during configuration of backup of blobs
     */
    @JvmName("kcsxraotlftjrwgl")
    public suspend fun containersList(values: List<Output<String>>) {
        this.containersList = Output.all(values)
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'BlobBackupDatasourceParameters'.
     */
    @JvmName("wlcfensgtgtxucql")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value List of containers to be backed up during configuration of backup of blobs
     */
    @JvmName("wyymlejcjylkevqt")
    public suspend fun containersList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containersList = mapped
    }

    /**
     * @param values List of containers to be backed up during configuration of backup of blobs
     */
    @JvmName("bofgtghdndecuymr")
    public suspend fun containersList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containersList = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'BlobBackupDatasourceParameters'.
     */
    @JvmName("aqwybwhpmlcocjqw")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): BlobBackupDatasourceParametersArgs = BlobBackupDatasourceParametersArgs(
        containersList = containersList ?: throw PulumiNullFieldException("containersList"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
