@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.CustomCopyOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Duration based custom options to copy
 * @property duration Data copied after given timespan
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'CustomCopyOption'.
 */
public data class CustomCopyOptionArgs(
    public val duration: Output<String>? = null,
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.CustomCopyOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.CustomCopyOptionArgs =
        com.pulumi.azurenative.dataprotection.inputs.CustomCopyOptionArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomCopyOptionArgs].
 */
@PulumiTagMarker
public class CustomCopyOptionArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value Data copied after given timespan
     */
    @JvmName("npkywyyycfefmpqx")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'CustomCopyOption'.
     */
    @JvmName("gxmccswvkyfwgqao")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Data copied after given timespan
     */
    @JvmName("widwdmhwgftlmtur")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'CustomCopyOption'.
     */
    @JvmName("fsyjxjeqdgtadjba")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): CustomCopyOptionArgs = CustomCopyOptionArgs(
        duration = duration,
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
