@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.DataStoreInfoBaseArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.DataStoreTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * DataStoreInfo base
 * @property dataStoreType type of datastore; Operational/Vault/Archive
 * @property objectType Type of Datasource object, used to initialize the right inherited type
 */
public data class DataStoreInfoBaseArgs(
    public val dataStoreType: Output<Either<String, DataStoreTypes>>,
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.DataStoreInfoBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.DataStoreInfoBaseArgs =
        com.pulumi.azurenative.dataprotection.inputs.DataStoreInfoBaseArgs.builder()
            .dataStoreType(
                dataStoreType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataStoreInfoBaseArgs].
 */
@PulumiTagMarker
public class DataStoreInfoBaseArgsBuilder internal constructor() {
    private var dataStoreType: Output<Either<String, DataStoreTypes>>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("sgjigowyfxhmdubs")
    public suspend fun dataStoreType(`value`: Output<Either<String, DataStoreTypes>>) {
        this.dataStoreType = value
    }

    /**
     * @param value Type of Datasource object, used to initialize the right inherited type
     */
    @JvmName("cxxcnbrsghxrvmrv")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("ncpvcuarkmqefyrd")
    public suspend fun dataStoreType(`value`: Either<String, DataStoreTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("mhbhxdadopthsqhc")
    public fun dataStoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("lixnqgyvsiynnfds")
    public fun dataStoreType(`value`: DataStoreTypes) {
        val toBeMapped = Either.ofRight<String, DataStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value Type of Datasource object, used to initialize the right inherited type
     */
    @JvmName("dxpuicuctrytcihe")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): DataStoreInfoBaseArgs = DataStoreInfoBaseArgs(
        dataStoreType = dataStoreType ?: throw PulumiNullFieldException("dataStoreType"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
