@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.FeatureSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class containing feature settings of vault
 * @property crossSubscriptionRestoreSettings CrossSubscriptionRestore Settings
 */
public data class FeatureSettingsArgs(
    public val crossSubscriptionRestoreSettings: Output<CrossSubscriptionRestoreSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.FeatureSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.FeatureSettingsArgs =
        com.pulumi.azurenative.dataprotection.inputs.FeatureSettingsArgs.builder()
            .crossSubscriptionRestoreSettings(
                crossSubscriptionRestoreSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [FeatureSettingsArgs].
 */
@PulumiTagMarker
public class FeatureSettingsArgsBuilder internal constructor() {
    private var crossSubscriptionRestoreSettings: Output<CrossSubscriptionRestoreSettingsArgs>? = null

    /**
     * @param value CrossSubscriptionRestore Settings
     */
    @JvmName("falqdranytxlbetl")
    public suspend
    fun crossSubscriptionRestoreSettings(`value`: Output<CrossSubscriptionRestoreSettingsArgs>) {
        this.crossSubscriptionRestoreSettings = value
    }

    /**
     * @param value CrossSubscriptionRestore Settings
     */
    @JvmName("qjvylvpefkqvhbht")
    public suspend
    fun crossSubscriptionRestoreSettings(`value`: CrossSubscriptionRestoreSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSubscriptionRestoreSettings = mapped
    }

    /**
     * @param argument CrossSubscriptionRestore Settings
     */
    @JvmName("xoiakdqxtxmpylyy")
    public suspend
    fun crossSubscriptionRestoreSettings(argument: suspend CrossSubscriptionRestoreSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CrossSubscriptionRestoreSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.crossSubscriptionRestoreSettings = mapped
    }

    internal fun build(): FeatureSettingsArgs = FeatureSettingsArgs(
        crossSubscriptionRestoreSettings = crossSubscriptionRestoreSettings,
    )
}
