@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.GetBackupVaultPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The name of the backup vault.
 */
public data class GetBackupVaultPlainArgs(
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.GetBackupVaultPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.GetBackupVaultPlainArgs =
        com.pulumi.azurenative.dataprotection.inputs.GetBackupVaultPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupVaultPlainArgs].
 */
@PulumiTagMarker
public class GetBackupVaultPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vybunntygfbdeioy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("yxmotrbcgdkwikga")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetBackupVaultPlainArgs = GetBackupVaultPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
