@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.ResourceGuardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property vaultCriticalOperationExclusionList List of critical operations which are not protected by this resourceGuard
 */
public data class ResourceGuardArgs(
    public val vaultCriticalOperationExclusionList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.ResourceGuardArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.ResourceGuardArgs =
        com.pulumi.azurenative.dataprotection.inputs.ResourceGuardArgs.builder()
            .vaultCriticalOperationExclusionList(
                vaultCriticalOperationExclusionList?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            ).build()
}

/**
 * Builder for [ResourceGuardArgs].
 */
@PulumiTagMarker
public class ResourceGuardArgsBuilder internal constructor() {
    private var vaultCriticalOperationExclusionList: Output<List<String>>? = null

    /**
     * @param value List of critical operations which are not protected by this resourceGuard
     */
    @JvmName("dsbhomuycctvrrvy")
    public suspend fun vaultCriticalOperationExclusionList(`value`: Output<List<String>>) {
        this.vaultCriticalOperationExclusionList = value
    }

    @JvmName("ypgfbavovreryqfj")
    public suspend fun vaultCriticalOperationExclusionList(vararg values: Output<String>) {
        this.vaultCriticalOperationExclusionList = Output.all(values.asList())
    }

    /**
     * @param values List of critical operations which are not protected by this resourceGuard
     */
    @JvmName("nnfmnxcvfgdnrisw")
    public suspend fun vaultCriticalOperationExclusionList(values: List<Output<String>>) {
        this.vaultCriticalOperationExclusionList = Output.all(values)
    }

    /**
     * @param value List of critical operations which are not protected by this resourceGuard
     */
    @JvmName("htqryhsuywwjsjxo")
    public suspend fun vaultCriticalOperationExclusionList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultCriticalOperationExclusionList = mapped
    }

    /**
     * @param values List of critical operations which are not protected by this resourceGuard
     */
    @JvmName("jybbgrapvdqffkup")
    public suspend fun vaultCriticalOperationExclusionList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCriticalOperationExclusionList = mapped
    }

    internal fun build(): ResourceGuardArgs = ResourceGuardArgs(
        vaultCriticalOperationExclusionList = vaultCriticalOperationExclusionList,
    )
}
