@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedTriggerContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule based trigger context
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ScheduleBasedTriggerContext'.
 * @property schedule Schedule for this backup
 * @property taggingCriteria List of tags that can be applicable for given schedule.
 */
public data class ScheduleBasedTriggerContextArgs(
    public val objectType: Output<String>,
    public val schedule: Output<BackupScheduleArgs>,
    public val taggingCriteria: Output<List<TaggingCriteriaArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedTriggerContextArgs> {
    override fun toJava():
        com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedTriggerContextArgs =
        com.pulumi.azurenative.dataprotection.inputs.ScheduleBasedTriggerContextArgs.builder()
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .schedule(schedule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taggingCriteria(
                taggingCriteria.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleBasedTriggerContextArgs].
 */
@PulumiTagMarker
public class ScheduleBasedTriggerContextArgsBuilder internal constructor() {
    private var objectType: Output<String>? = null

    private var schedule: Output<BackupScheduleArgs>? = null

    private var taggingCriteria: Output<List<TaggingCriteriaArgs>>? = null

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ScheduleBasedTriggerContext'.
     */
    @JvmName("wlyxxytkpmcoejrf")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Schedule for this backup
     */
    @JvmName("yqojjfmnlnsfjpme")
    public suspend fun schedule(`value`: Output<BackupScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value List of tags that can be applicable for given schedule.
     */
    @JvmName("ffuxnujxslmwtoae")
    public suspend fun taggingCriteria(`value`: Output<List<TaggingCriteriaArgs>>) {
        this.taggingCriteria = value
    }

    @JvmName("dhrghgctyrrpsdut")
    public suspend fun taggingCriteria(vararg values: Output<TaggingCriteriaArgs>) {
        this.taggingCriteria = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be applicable for given schedule.
     */
    @JvmName("mojrwottkxydlryo")
    public suspend fun taggingCriteria(values: List<Output<TaggingCriteriaArgs>>) {
        this.taggingCriteria = Output.all(values)
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ScheduleBasedTriggerContext'.
     */
    @JvmName("vxnwjhdhtnfxrlsa")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Schedule for this backup
     */
    @JvmName("gmvasnpgysugqtxa")
    public suspend fun schedule(`value`: BackupScheduleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Schedule for this backup
     */
    @JvmName("qpgwetqwqjeceqgt")
    public suspend fun schedule(argument: suspend BackupScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = BackupScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value List of tags that can be applicable for given schedule.
     */
    @JvmName("byierrajdkeycjth")
    public suspend fun taggingCriteria(`value`: List<TaggingCriteriaArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggingCriteria = mapped
    }

    /**
     * @param argument List of tags that can be applicable for given schedule.
     */
    @JvmName("fhryxsxscvucggdr")
    public suspend
    fun taggingCriteria(argument: List<suspend TaggingCriteriaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TaggingCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taggingCriteria = mapped
    }

    /**
     * @param argument List of tags that can be applicable for given schedule.
     */
    @JvmName("xbeognpjqiwvhxcs")
    public suspend fun taggingCriteria(
        vararg
        argument: suspend TaggingCriteriaArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TaggingCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taggingCriteria = mapped
    }

    /**
     * @param argument List of tags that can be applicable for given schedule.
     */
    @JvmName("tmcaejdnqqvwyxtf")
    public suspend fun taggingCriteria(argument: suspend TaggingCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TaggingCriteriaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taggingCriteria = mapped
    }

    /**
     * @param values List of tags that can be applicable for given schedule.
     */
    @JvmName("bumjbipwwewrvchf")
    public suspend fun taggingCriteria(vararg values: TaggingCriteriaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggingCriteria = mapped
    }

    internal fun build(): ScheduleBasedTriggerContextArgs = ScheduleBasedTriggerContextArgs(
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        schedule = schedule ?: throw PulumiNullFieldException("schedule"),
        taggingCriteria = taggingCriteria ?: throw PulumiNullFieldException("taggingCriteria"),
    )
}
