@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.SecretStoreResourceArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.SecretStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a secret store resource.
 * @property secretStoreType Gets or sets the type of secret store
 * @property uri Uri to get to the resource
 * @property value Gets or sets value stored in secret store resource
 */
public data class SecretStoreResourceArgs(
    public val secretStoreType: Output<Either<String, SecretStoreType>>,
    public val uri: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.SecretStoreResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.SecretStoreResourceArgs =
        com.pulumi.azurenative.dataprotection.inputs.SecretStoreResourceArgs.builder()
            .secretStoreType(
                secretStoreType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .uri(uri?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretStoreResourceArgs].
 */
@PulumiTagMarker
public class SecretStoreResourceArgsBuilder internal constructor() {
    private var secretStoreType: Output<Either<String, SecretStoreType>>? = null

    private var uri: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Gets or sets the type of secret store
     */
    @JvmName("djlfouqyunxnwxfb")
    public suspend fun secretStoreType(`value`: Output<Either<String, SecretStoreType>>) {
        this.secretStoreType = value
    }

    /**
     * @param value Uri to get to the resource
     */
    @JvmName("lemtnmhoyyfcdpdv")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Gets or sets value stored in secret store resource
     */
    @JvmName("bichfyxiffppvdkw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Gets or sets the type of secret store
     */
    @JvmName("qphohtiymasbunqp")
    public suspend fun secretStoreType(`value`: Either<String, SecretStoreType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStoreType = mapped
    }

    /**
     * @param value Gets or sets the type of secret store
     */
    @JvmName("vtdgonesarchfxnk")
    public fun secretStoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStoreType = mapped
    }

    /**
     * @param value Gets or sets the type of secret store
     */
    @JvmName("emhjuwjlmotjsnqo")
    public fun secretStoreType(`value`: SecretStoreType) {
        val toBeMapped = Either.ofRight<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStoreType = mapped
    }

    /**
     * @param value Uri to get to the resource
     */
    @JvmName("nsjnblfvdkttplib")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Gets or sets value stored in secret store resource
     */
    @JvmName("elvrxgemffwdetet")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretStoreResourceArgs = SecretStoreResourceArgs(
        secretStoreType = secretStoreType ?: throw PulumiNullFieldException("secretStoreType"),
        uri = uri,
        `value` = `value`,
    )
}
