@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.SoftDeleteSettingsArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.SoftDeleteState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Soft delete related settings
 * @property retentionDurationInDays Soft delete retention duration
 * @property state State of soft delete
 */
public data class SoftDeleteSettingsArgs(
    public val retentionDurationInDays: Output<Double>? = null,
    public val state: Output<Either<String, SoftDeleteState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.SoftDeleteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.SoftDeleteSettingsArgs =
        com.pulumi.azurenative.dataprotection.inputs.SoftDeleteSettingsArgs.builder()
            .retentionDurationInDays(retentionDurationInDays?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SoftDeleteSettingsArgs].
 */
@PulumiTagMarker
public class SoftDeleteSettingsArgsBuilder internal constructor() {
    private var retentionDurationInDays: Output<Double>? = null

    private var state: Output<Either<String, SoftDeleteState>>? = null

    /**
     * @param value Soft delete retention duration
     */
    @JvmName("fujkdmgxmwxrgdjh")
    public suspend fun retentionDurationInDays(`value`: Output<Double>) {
        this.retentionDurationInDays = value
    }

    /**
     * @param value State of soft delete
     */
    @JvmName("lclqfvwmgbmrrkxr")
    public suspend fun state(`value`: Output<Either<String, SoftDeleteState>>) {
        this.state = value
    }

    /**
     * @param value Soft delete retention duration
     */
    @JvmName("blcfevafitbruetc")
    public suspend fun retentionDurationInDays(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDurationInDays = mapped
    }

    /**
     * @param value State of soft delete
     */
    @JvmName("nhekqnhthovekijx")
    public suspend fun state(`value`: Either<String, SoftDeleteState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of soft delete
     */
    @JvmName("hwtdbsttnigfkquf")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoftDeleteState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of soft delete
     */
    @JvmName("ifcdjotqgnplarhp")
    public fun state(`value`: SoftDeleteState) {
        val toBeMapped = Either.ofRight<String, SoftDeleteState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SoftDeleteSettingsArgs = SoftDeleteSettingsArgs(
        retentionDurationInDays = retentionDurationInDays,
        state = state,
    )
}
