@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Tagging criteria
 * @property criteria Criteria which decides whether the tag can be applied to a triggered backup.
 * @property isDefault Specifies if tag is default.
 * @property tagInfo Retention tag information
 * @property taggingPriority Retention Tag priority.
 */
public data class TaggingCriteriaArgs(
    public val criteria: Output<List<ScheduleBasedBackupCriteriaArgs>>? = null,
    public val isDefault: Output<Boolean>,
    public val tagInfo: Output<RetentionTagArgs>,
    public val taggingPriority: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs =
        com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs.builder()
            .criteria(
                criteria?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isDefault(isDefault.applyValue({ args0 -> args0 }))
            .tagInfo(tagInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taggingPriority(taggingPriority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaggingCriteriaArgs].
 */
@PulumiTagMarker
public class TaggingCriteriaArgsBuilder internal constructor() {
    private var criteria: Output<List<ScheduleBasedBackupCriteriaArgs>>? = null

    private var isDefault: Output<Boolean>? = null

    private var tagInfo: Output<RetentionTagArgs>? = null

    private var taggingPriority: Output<Double>? = null

    /**
     * @param value Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("wilcirxstqvichct")
    public suspend fun criteria(`value`: Output<List<ScheduleBasedBackupCriteriaArgs>>) {
        this.criteria = value
    }

    @JvmName("wwdptwwtunhofuln")
    public suspend fun criteria(vararg values: Output<ScheduleBasedBackupCriteriaArgs>) {
        this.criteria = Output.all(values.asList())
    }

    /**
     * @param values Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("jpprkonewwqocgro")
    public suspend fun criteria(values: List<Output<ScheduleBasedBackupCriteriaArgs>>) {
        this.criteria = Output.all(values)
    }

    /**
     * @param value Specifies if tag is default.
     */
    @JvmName("jaogqfqtqdtamnmv")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value Retention tag information
     */
    @JvmName("eqgsparrktlydytf")
    public suspend fun tagInfo(`value`: Output<RetentionTagArgs>) {
        this.tagInfo = value
    }

    /**
     * @param value Retention Tag priority.
     */
    @JvmName("opxyfejnfnwtnpof")
    public suspend fun taggingPriority(`value`: Output<Double>) {
        this.taggingPriority = value
    }

    /**
     * @param value Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("nhckdmgptgikjqpl")
    public suspend fun criteria(`value`: List<ScheduleBasedBackupCriteriaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("ifkmhltdxpkiuead")
    public suspend
    fun criteria(argument: List<suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("rudushvrftreicsm")
    public suspend fun criteria(
        vararg
        argument: suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("ccplxdiaamclnjuh")
    public suspend fun criteria(argument: suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param values Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("gbhfddsvbgfbkuvf")
    public suspend fun criteria(vararg values: ScheduleBasedBackupCriteriaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param value Specifies if tag is default.
     */
    @JvmName("hkrfkgdoyaasvmwp")
    public suspend fun isDefault(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value Retention tag information
     */
    @JvmName("qydtjnjottkbpnri")
    public suspend fun tagInfo(`value`: RetentionTagArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagInfo = mapped
    }

    /**
     * @param argument Retention tag information
     */
    @JvmName("etljwfjbonaoxpxk")
    public suspend fun tagInfo(argument: suspend RetentionTagArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagInfo = mapped
    }

    /**
     * @param value Retention Tag priority.
     */
    @JvmName("ntcspsdwxfqpseio")
    public suspend fun taggingPriority(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggingPriority = mapped
    }

    internal fun build(): TaggingCriteriaArgs = TaggingCriteriaArgs(
        criteria = criteria,
        isDefault = isDefault ?: throw PulumiNullFieldException("isDefault"),
        tagInfo = tagInfo ?: throw PulumiNullFieldException("tagInfo"),
        taggingPriority = taggingPriority ?: throw PulumiNullFieldException("taggingPriority"),
    )
}
