@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * BackupInstance Resource
 * @property id Proxy Resource Id represents the complete path to the resource.
 * @property name Proxy Resource name associated with the resource.
 * @property properties BackupInstanceResource properties
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Proxy Resource tags.
 * @property type Proxy Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetBackupInstanceResult(
    public val id: String,
    public val name: String,
    public val properties: BackupInstanceResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.GetBackupInstanceResult):
            GetBackupInstanceResult = GetBackupInstanceResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupInstanceResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
